.H 1 Bugs
Known bugs are listed below.
If you discover a new one, please report it to
research!dak or dak@research.att.com.
.P
On some types of processors if a program is suspended in the middle of a
function's prologue the values of arguments in the Process window's
top activation record are displayed incorrectly.
Pi determines the number of activation records by following the frame pointers,
and if a process is stopped in a prologue before the frame pointer is updated,
the new activation record may use the wrong frame pointer.
This can happen if the process is stopped asynchronously with "stop",
or a function is stepped into from the Assembler window.
Stepping a few more instructions from the Assembler window remedies the problem.
.H 2 "Bugs in SunOS 4.X"
These bugs occur with SunOS releases 4.X.
They are caused by problems with the ptrace system call that is available for
debugging.
The bugs are not present in SunOS releases 5.0 (Solaris 2.0) and later,
as mounted processes are used for debugging.
.P
The "open child" line menu entry in the Unix Pi window is not very useful.
When a process controlled by pi calls fork(),
the child process inherits the parent's breakpoints.
Under SunOS 4.X, if the child hits any of these breakpoints before pi
attaches to it, the SIGTRAP signal generated kills the process,
instead of suspending it.
.P
A parent process waiting for a child process to finish with wait() blocks
indefinitely if pi is examing the child process when the child exits or dies.
A bug in the operating system causes the debugger to receive the information
returned by wait() instead of the parent.
This happens if you start a foreground process in a shell,
attach pi to it, and then the process dies.
A solution is to start the program with hang.
While hang gets stuck in wait(), the shell waits for hang,
and not the process being debugged - so killing hang
forces the shell to returns from its call to wait().
.P
If pi examines a process while it is blocked in certain system calls
the system call returns -1 and errno is set to EINTR,
behaving as if a signal was received and serviced.
The operating system's implementation of ptrace() unblocks the
system call in the target process to service the debug request,
and sometime doesn't restart it.
While some system calls, such as read(), restart automatically
others, such as recv(), do not.
The only solution is to add code to your program that checks
if the system call returned -1 and errno==EINTR, and if true, repeat the call.
.H 2 "Bugs on Sparcs"
When function calls are evaluated in Frame windows, only 6 arguments
or less may be passed to the function.
Also, register arguments are passed incorrectly when function calls
are evaluated in Frame windows with code generated by Sun's compiler.
